Type Demo9Screen Extends TScreen

	Field polyList:TList = CreateList()
	Field curPoly:TPolyBody
	
	Field border:TBorder
	
	Method Draw(delta:Float)
		
		border.Draw()
		For Local p:TPolyBody = EachIn polylist
			p.Draw()
		Next
		If curPoly <> Null Then
			DrawLine(curPoly._vertices[curPoly.Count() - 1].X, curPoly._vertices[curPoly.Count() - 1].Y, MouseX(), MouseY())
		End If
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
	End Method
	
	Field _firstRun:Int = True
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
			_firstRun = False
		EndIf
		HandleMouseInput()
		HandleKeyboardInput()
		physics.Update(delta)
	End Method
	
	Method Load()
		physics = TPhysicsSimulator.Create(Vector2.Create(0, 150))
		view = TPhysicsSimulatorView.Create(physics)
		
		Local borderWidth:Int = TDemo.gfxHeight *.05
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2, TDemo.gfxHeight / 2)
		
		border = TBorder.Create(TDemo.gfxWidth, TDemo.gfxHeight, borderWidth, center)
		border.Load(physics)
	End Method
	
	Method Unload()
		
	End Method
	
	Method OnEscapeKeyHit()
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
	End Method
	
	Method GetTitle:String()
		Return "Concave Polygon Collision"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo demonstrates concave geometry collisions")
		sb.AppendLine("which allows more freedom in the design of physical objects.")
		sb.AppendLine("")
		sb.AppendLine("Mouse")
		sb.AppendLine(" -Draw : hold left click and draw a shape.")
		sb.AppendLine(" - Hold down left button on a physical body and drag")
		Return sb
	End Method
	
	Method HandleKeyboardInput()
		If Self.mousePickSpring = Null Then
			Local md:Int = ScreenManager.Instance().GetInput().CurrentLeftMouse' MouseDown(1)		
			If md Then
				If curPoly = Null Then
					curPoly = TPolyBody.Create()
					polylist.AddLast(curPoly)
					curPoly.AddVertex(Vector2.Create(MouseX(), MouseY()))
				End If
				Local lastPoint:Vector2 = curPoly._vertices[curPoly.Count() - 1]
				Local mouseVec:Vector2 = Vector2.Create(MouseX(), MouseY())
				If Vector2.Distance(lastPoint, mousevec) > 10 Then
					curPoly.AddVertex(mouseVec)
				End If
			Else
				If curPoly <> Null Then
					If curPoly.Count() > 2 Then
						curPOly.Complete(physics)
						Game._currentTime = MilliSecs() ' to stop the loop from trying to catch up after creating a poly body.
						curPoly = Null
					Else
						polylist.Remove(curPOly)
						curPoly = Null
					End If
				End If
			End If
		End If
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
	
End Type
